package com.ptteng.yi.etl;


import com.ptteng.yi.nucleus.model.Center;
import com.ptteng.yi.nucleus.model.Coach;
import com.ptteng.yi.nucleus.model.FreezeUser;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.service.CenterService;
import com.ptteng.yi.nucleus.service.CoachService;
import com.ptteng.yi.nucleus.service.FreezeUserService;
import com.ptteng.yi.nucleus.service.StudentsService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class UnfreezeEtl {

    private static final int TASK_LEN = 200;// 一次任务检测的条数

    private static final long SLEEP_MILLISECOND = 86400000;// 空转任务间隔休息毫秒数


    private static final Log log = LogFactory.getLog(UnfreezeEtl.class);


    private CenterService centerService;


    private CoachService coachService;


    private StudentsService studentsService;


    private FreezeUserService freezeUserService;


    private Long interval=2000L;


    public UnfreezeEtl() {
        super();
    }

    /**
     * ETL主进程
     * @throws InterruptedException
     */
    public void process() throws InterruptedException {

        while (true) {
            try {
                /* 获取到期时间点 */
                Long currentTime = System.currentTimeMillis();
                log.info(" currentTime =============" + currentTime);

                /* 获取超时订单,单次最多200条 */
                Map<String, Object> conditions = new HashMap<String, Object>();
                conditions.put("status",0);
                conditions.put("thaw_time & <=", currentTime);
                conditions.put("@query", "id ");
                conditions.put("@table","freeze_user");
                List<Long> ids = this.freezeUserService.getIdsByDynamicCondition(FreezeUser.class, conditions, 0, TASK_LEN);
                log.info("unfreeze ids is: " + ids);

                 /* 校验是否有到期的账号ids */
                /* 没有,则休眠一段时间后再启动一次 */
                if(CollectionUtils.isEmpty(ids)){
                    log.info("unfreeze-etl don`t get any id ,sleep " + interval + " ms ");
                    Thread.sleep(interval);
                /* 有,则按账号Ids获取订单进行处理 */
                } else {
                    log.info("unfreeze-etl get accountIds :" + ids.size());
                    List<FreezeUser> freezeUsers = this.freezeUserService.getObjectsByIds(ids);

                    for(FreezeUser freezeUser: freezeUsers) {
                        Integer type = freezeUser.getType();
                        switch (type){
                            case FreezeUser.CENTER_TYPE:
                                Center center = centerService.getObjectById(freezeUser.getUid());
                                center.setStatus(Center.STATUS_UNFREEZE);
                                centerService.update(center);
                                break;
                            case FreezeUser.COACH_TYPE:
                                Coach coach = coachService.getObjectById(freezeUser.getUid());
                                coach.setStatus(Coach.STATUS_ON);
                                coachService.update(coach);
                                break;
                            case FreezeUser.STUDENT_TYPE:
                                Students students = studentsService.getObjectById(freezeUser.getUid());
                                students.setStatus(Students.STATUS_ON);
                                studentsService.update(students);
                                break;
                            default:
                        }

                        freezeUser.setStatus(1);
                        freezeUserService.update(freezeUser);
                    }

                    Thread.sleep(interval);
                }


            } catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(interval);
                log.error("process check expire-user error ,sleep " + t.getMessage());
            }
        }
    }


    public CenterService getCenterService() {
        return centerService;
    }
    public void setCenterService(CenterService centerService) {this.centerService = centerService;}

    public CoachService getCoachService() {return coachService;}
    public void setCoachService(CoachService coachService) { this.coachService = coachService; }

    public StudentsService getStudentsService() { return  studentsService; }
    public void setStudentsService (StudentsService studentsService) { this.studentsService = studentsService; }

    public FreezeUserService getFreezeUserService() { return  freezeUserService; }
    public void setFreezeUserService (FreezeUserService freezeUserService) { this.freezeUserService = freezeUserService; }


    public Long getInterval() {return interval;}
    public void setInterval(Long interval) {
        this.interval = interval;
    }
}
